#!/usr/bin/env python
# -*- coding: utf_8 -*-

from datetime import datetime
from application.app import db
from models.{{ config['name'] }} import {{ config['name'] | letterUpper }}Model
from webcreator.log import logger
from webcreator.response import ResponseCode

class {{ config['name'] | letterUpper }}Resource(object):
    def __init__(self):
        super().__init__()

    def get(self, uuid, params):
        # handle business
        filters = [{{ config['name'] | letterUpper }}Model.is_delete==False, {{ config['name'] | letterUpper }}Model.uuid==uuid]
        result = {{ config['name'] | letterUpper }}Model.query.filter(*filters).first()
        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def getList(self, params):
        # handle business
        logger.warn(params)
        filters = [{{ config['name'] | letterUpper }}Model.is_delete==False]
        result = {{ config['name'] | letterUpper }}Model.query.filter(*filters).order_by({{ config['name'] | letterUpper }}Model.create_at).paginate(params.get('page', 1), params.get('pageSize', 10), error_out=False)

        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def post(self, params, jwt={}):
        # handle business
        result = {{ config['name'] | letterUpper }}Model.query.filter({{ config['name'] | letterUpper }}Model.{{ config["model"]["fields"][0]["name"] }} == params.get('{{ config["model"]["fields"][0]["name"] }}')).first()
        if result and result.is_delete:
            result.is_delete = False
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        elif result and result.is_delete == False:
            return False, ResponseCode.HTTP_INVAILD_REQUEST

        result = {{ config['name'] | letterUpper }}Model(**params)
        db.session.add(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS

    def put(self, uuid, params, jwt={}):
        # handle business
        result = {{ config['name'] | letterUpper }}Model.query.filter({{ config['name'] | letterUpper }}Model.uuid==uuid).first()
        if not result:
            return None, ResponseCode.HTTP_NOT_FOUND

        if params:
            for key, value in params.items():
                if value != None: setattr(result, key, value)
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        else:
            return False, ResponseCode.HTTP_INVAILD_REQUEST

    def delete(self, uuid, jwt={}):
        # handle business
        result = {{ config['name'] | letterUpper }}Model.query.filter({{ config['name'] | letterUpper }}Model.uuid==uuid).first()
        if not result:
            return False, ResponseCode.HTTP_NOT_FOUND

        result.update_by = jwt.get("id", "")
        result.update_date = datetime.now()
        result.is_delete = True
        db.session.delete(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS

{{ config["name"] }}Manager = {{ config['name'] | letterUpper }}Resource()
