'''
Author: your name
Date: 2021-06-15 17:40:09
LastEditTime: 2021-06-30 18:09:51
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\resources\manager.py
'''
# -*- coding: utf-8 -*-
from tornado.wsgi import WSGIContainer
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
from flask_script import Manager
from flask_migrate import Migrate
from application.app import create_app, db
from application.config import config

# 根据配置初始化app
app = create_app(config)
migrate = Migrate(app, db)
manager = Manager(app)

@manager.command
def run():
    """
    生产模式启动命令函数
    To use: python3 manager.py run
    """
    # app.logger.setLevel(app.config.get('LOG_LEVEL', logging.INFO))

    http_server = HTTPServer(WSGIContainer(app))
    http_server.listen(3000, address='127.0.0.1', xheaders=True)
    IOLoop.instance().start()

@manager.command
def debug():
    """
    debug模式启动命令函数
    To use: python3 manager.py debug
    """
    # app.logger.setLevel(logging.DEBUG)
    app.run(debug=True, port=3000, host='127.0.0.1')

if __name__ == '__main__':
    manager.run()
