import "./Header.less";
import { Layout } from "ant-design-vue";
import GlobalHeader from "@/components/GlobalHeader";
import TopNavHeader from "@/components/TopNavHeader";
import { mapGetters } from "vuex";
const { Header } = Layout;
const HeaderView = {
  props: ["menuData", "logo"],
  computed: {
    ...mapGetters({
      settings: "global/settings",
      collapsed: "global/getChangeLayoutCollapsed",
    }),
    sideMenuWidth() {
      return this.collapsed ? "80px" : "256px";
    },
    headerStyle() {
      const { layout, fixedHeader } = this.settings;

      let width =
        fixedHeader && layout !== "topmenu"
          ? `calc(100% - ${this.sideMenuWidth})`
          : "100%";
      let position = fixedHeader ? "fixed" : "static";
      return `width: ${width};position: ${position};top: 0;z-index: 1061;transition: width 0.2s;padding: 0;`;
    },
  },
  render() {
    const { menuData, logo } = this;
    const { layout, navTheme, fixedHeader, leftMenuTitle } = this.settings;
    const isTop = layout === "topmenu";
    const isMobile = false;

    return (
      <div>
        <Header style={this.headerStyle}>
          {isTop && !isMobile ? (
            // <TopNavHeader
            //     theme={navTheme}
            //     mode="horizontal"
            //     Authorized={Authorized}
            //     onCollapse={handleMenuCollapse}
            //     onNoticeClear={this.handleNoticeClear}
            //     onMenuClick={this.handleMenuClick}
            //     onNoticeVisibleChange={this.handleNoticeVisibleChange}
            //     {...this.props}
            // />
            <TopNavHeader
              theme={navTheme}
              layout={layout}
              mode="horizontal"
              menuData={menuData}
              logo={logo}
              title={leftMenuTitle}
            />
          ) : (
            // <GlobalHeader
            //     onCollapse={handleMenuCollapse}
            //     onNoticeClear={this.handleNoticeClear}
            //     onMenuClick={this.handleMenuClick}
            //     onNoticeVisibleChange={this.handleNoticeVisibleChange}
            //     {...this.props}
            // />
            <GlobalHeader theme={navTheme} layout={layout} />
          )}
        </Header>
        <div v-show={fixedHeader} class="placeholder-element" />
      </div>
    );
  },
};
export default HeaderView;
