/*
 * @Author: your name
 * @Date: 2021-07-15 09:33:39
 * @LastEditTime: 2021-07-23 00:35:38
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \evm-store\tools\frontend\src\api\openapi.js
 */
import request from "@/utils/request";

export function menuNav() {
  return request({
      url: "/api/v1/menu",
      method: 'get'
  })
}

export function workbench() {
  return request({
      url: "/api/v1/api/workbench",
      method: 'get'
  })
}

export function getWatchList() {
  return request({
    url: "/api/v1/monitor/watch",
    method: "get",
  });
}

export function getMonitorData(params) {
  return request({
    url: "/api/v1/monitor",
    method: "get",
    params,
  });
}

export function users(params) {
  return request({
    url: "https://randomuser.me/api",
    method: "get",
    params,
  });
}

export function postLogin(params) {
  return request({
    url: "/api/v1/login",
    method: "post",
    data: params,
  });
}

export function updateApplication(uuid, params) {
  return request({
    url: `/api/v1/app/${uuid}`,
    method: "put",
    data: params,
  });
}

export function postApplication(params) {
  return request({
    url: "/api/v1/app",
    method: "post",
    data: params,
  });
}

export function getApplicationList(params) {
  return request({
    url: "/api/v1/app",
    method: "get",
    params,
  });
}

export function rebuildApplication(uuid) {
  return request({
    url: `/api/v1/app/${uuid}`,
    method: "get",
  });
}

export function deleteApplication(uuid) {
  return request({
    url: `/api/v1/app/${uuid}`,
    method: "delete",
  });
}

export function getPackageList(params) {
  return request({
    url: "/api/v1/package",
    method: "get",
    params,
  });
}

export function updateReview(params) {
  return request({
    url: "/api/v1/api/app-review",
    method: "post",
    data: params,
  });
}

export function updateLauncher(params) {
  return request({
    url: "/api/v1/api/app-review",
    method: "get",
    params,
  });
}

export function getDeviceList(params) {
  return request({
    url: "/api/v1/device",
    method: "get",
    params,
  });
}

export function postDevice(params) {
  return request({
    url: "/api/v1/device",
    method: "post",
    data: params,
  });
}

export function deleteDevice(uuid) {
  return request({
    url: `/api/v1/device/${uuid}`,
    method: "delete",
  });
}

export function updateDevice(uuid, params) {
  return request({
    url: `/api/v1/device/${uuid}`,
    method: "put",
    data: params,
  });
}

export function getConvertString(params) {
  return request({
    url: "/api/v1/api/convert-to-c-string",
    method: "post",
    data: params,
  });
}
