import Cookies from "js-cookie";
import $ls from "local-storage";
import { resetRouter } from "@/router";

const TokenKey = "Authorization";
const NameKey = "name";
const RoleKey = "role";
const themeKey = "theme";
const styleKey = "style";
const widthKey = "isFixedWidth";
const headerKey = "isFixedHeader";
const sideKey = "isFixedSide";
const disableWidthKey = "isDisableWidth";
const disableSideKey = "isDisableSide";
const iconThemeKey = "iconTheme";

export function getToken() {
  return Cookies.get(TokenKey);
}
export function getName() {
  return $ls.get(NameKey);
}
export function getTheme() {
  return $ls.get(themeKey);
}
export function getRole() {
  return $ls.get(RoleKey);
}
export function getStyle() {
  return $ls.get(styleKey);
}
export function getFixedWidth() {
  return $ls.get(widthKey);
}
export function getFixedHeader() {
  return $ls.get(headerKey);
}
export function getFixedSide() {
  return $ls.get(sideKey);
}
export function getDisableWidth() {
  return $ls.get(disableWidthKey);
}
export function getDisableSide() {
  return $ls.get(disableSideKey);
}
export function getIconTheme() {
  return $ls.get(iconThemeKey);
}

const state = {
  token: getToken(),
  name: getName(),
  avatar: "",
  password: "",
  role: getRole(),
  appTheme: getTheme() || "one",
  appStyle: getStyle() || "dark",
  isFixedWidth: getFixedWidth() || false,
  isFixedHeader: getFixedHeader() || false,
  isFixedSide: getFixedSide() || false,
  isDisableWidth: getDisableWidth() || true,
  isDisableSide: getDisableSide() || false,
  iconTheme: getIconTheme() || "default-iconTheme",
};

const mutations = {
  login: (state, form) => {
    state.name = form.username;
    state.password = form.password;
  },
  setToken: (state, token) => {
    state.token = token;
    Cookies.set(TokenKey, token);
  },
  removeToken: (state, token) => {
    state.token = "";
    Cookies.remove(TokenKey, token);
  },
  setName: (state, name) => {
    state.name = name;
    $ls.set(NameKey, name);
  },
  removeName: (state, name) => {
    state.name = "";
    $ls.remove(NameKey, name);
  },
  setRole: (state, role) => {
    state.role = role;
    $ls.set(RoleKey, role);
  },
  removeRole: (state, role) => {
    state.role = "";
    $ls.remove(RoleKey, role);
  },
  setAvatar: (state, avatar) => {
    state.avatar = avatar;
  },
  setTheme: (state, subject) => {
    state.appTheme = subject;
    $ls.set(themeKey, subject);
  },
  removeTheme: (state) => {
    state.appTheme = "one";
    $ls.remove(themeKey);
  },
  setAppStyle: (state, style) => {
    state.appStyle = style;
    $ls.set(styleKey, style);
  },
  removeAppStyle: (state) => {
    state.appStyle = "dark";
    $ls.remove(styleKey);
  },
  setFixedWidth: (state, boolean) => {
    state.isFixedWidth = boolean;
    $ls.set(widthKey, boolean);
  },
  removeFixedWidth: (state) => {
    state.isFixedWidth = false;
    $ls.remove(widthKey);
  },
  setFixedHeader: (state, boolean) => {
    state.isFixedHeader = boolean;
    $ls.set(headerKey, boolean);
  },
  removeFixedHeader: (state) => {
    state.isFixedHeader = false;
    $ls.remove(headerKey);
  },
  setFixedSide: (state, boolean) => {
    state.isFixedSide = boolean;
    $ls.set(sideKey, boolean);
  },
  removeFixedSide: (state) => {
    state.isFixedSide = false;
    $ls.remove(sideKey);
  },
  setDisableWidth: (state, boolean) => {
    state.isDisableWidth = boolean;
    $ls.set(disableWidthKey, boolean);
  },
  removeDisableWidth: (state) => {
    state.isDisableWidth = false;
    $ls.remove(disableWidthKey);
  },
  setDisableSide: (state, boolean) => {
    state.isDisableSide = boolean;
    $ls.set(disableSideKey, boolean);
  },
  removeDisableSide: (state) => {
    state.isDisableSide = false;
    $ls.remove(disableSideKey);
  },
  setIconTheme: (state, string) => {
    state.iconTheme = string;
    $ls.set(iconThemeKey, string);
  },
  removeIconTheme: (state) => {
    state.iconTheme = "default-iconTheme";
    $ls.remove(iconThemeKey);
  },
};

const actions = {
  login({ commit }, form) {
    commit("login", form);
  },
  setToken({ commit }, token) {
    commit("setToken", token);
  },
  removeToken({ commit }) {
    commit("removeToken");
    resetRouter();
  },
  setName({ commit }, name) {
    commit("setName", name);
  },
  removeName({ commit }, name) {
    commit("removeName", name);
  },
  setRole({ commit }, role) {
    commit("setRole", role);
  },
  removeRole({ commit }, role) {
    commit("removeRole", role);
  },
  setTheme({ commit }, subject) {
    commit("setTheme", subject);
  },
  removeTheme({ commit }, subject) {
    commit("removeTheme", subject);
  },
  setAppStyle({ commit }, style) {
    commit("setAppStyle", style);
  },
  removeAppStyle({ commit }, style) {
    commit("removeAppStyle", style);
  },
};

export default {
  namespaced: true,
  state,
  mutations,
  actions,
};
