'''
Author: your name
Date: 2021-04-22 18:04:15
LastEditTime: 2021-07-14 18:38:28
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\resources\webcreator\log.py
'''
# -*- coding: utf_8 -*-

import os
import logging
from logging.handlers import RotatingFileHandler

logPath = os.getcwd() + os.path.sep + "logs"
if not os.path.exists(logPath):
    os.makedirs(logPath)

fh = RotatingFileHandler("logs/running.log", maxBytes=10 * 1024 * 1024, backupCount=100)
fh.setLevel(logging.DEBUG)

ch = logging.StreamHandler()
ch.setLevel(logging.DEBUG)

formatter = logging.Formatter('[%(asctime)s][%(levelname)7s][in %(pathname)s -> %(funcName)s line:%(lineno)s] %(message)s')
fh.setFormatter(formatter)
ch.setFormatter(formatter)

logger = logging.root
logger.setLevel(logging.DEBUG)
logger.addHandler(fh)
logger.addHandler(ch)