'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-28 17:16:06
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\views\menu.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

import traceback
from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result

class MenuList(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        self.parser = RequestParser()

    def get(self):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()
        result = [
            {
                "id": "1044886626813353984",
                "parentId": "0",
                "name": "dashboard",
                "path": "/dashboard",
                "icon": "dashboard",
                "leaf": False,
                "children": [
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "analysis",
                        "path": "/dashboard/analysis",
                        "leaf": True,
                        "children": []
                    },
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "workplace",
                        "path": "/dashboard/workplace",
                        "leaf": True,
                        "children": []
                    }
                ]
            },
            {
                "id": "1044886626813353984",
                "parentId": "0",
                "name": "system",
                "path": "/system",
                "icon": "setting",
                "leaf": False,
                "children": [
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "setting",
                        "path": "/system/setting",
                        "leaf": False,
                        "children": [
                            {
                                "id": "1044886630026190848",
                                "parentId": "1044886629921333248",
                                "name": "menu",
                                "path": "/system/setting/menu",
                                "leaf": True,
                                "children": []
                            },
                            {
                                "id": "1044886630122659840",
                                "parentId": "1044886629921333248",
                                "name": "module",
                                "path": "/system/setting/module",
                                "leaf": True,
                                "children": []
                            },
                            {
                                "id": "1044886630122659841",
                                "parentId": "1044886629921333248",
                                "name": "file-manager",
                                "path": "/system/setting/file-manager",
                                "leaf": True,
                                "children": []
                            }
                        ]
                    },
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "role",
                        "path": "/system/role",
                        "leaf": True
                    },
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "admin",
                        "path": "/system/admin",
                        "leaf": True
                    }
                ]
            },
            {
                "id": "1044886626813353984",
                "icon": "shop",
                "parentId": "0",
                "name": "application",
                "path": "/application",
                "leaf": False,
                "children": [
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "index",
                        "path": "/application/index",
                        "leaf": True,
                        "children": []
                    },
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "manager",
                        "path": "/application/manager",
                        "leaf": True,
                        "children": []
                    }
                ]
            },
            {
                "id": "1044886626813353984",
                "icon": "usb",
                "parentId": "0",
                "name": "device",
                "path": "/device",
                "leaf": False,
                "children": [
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "index",
                        "path": "/device/index",
                        "leaf": True,
                        "children": []
                    }
                ]
            },
            {
                "id": "1044886626813353984",
                "icon": "tool",
                "parentId": "0",
                "name": "tools",
                "path": "/tools",
                "leaf": False,
                "children": [
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "monitor",
                        "path": "/tools/monitor",
                        "leaf": True,
                        "children": []
                    },
                    {
                        "id": "1044886629921333248",
                        "parentId": "1044886626813353984",
                        "name": "index",
                        "path": "/tools/index",
                        "leaf": True,
                        "children": []
                    }
                ]
            }
        ]
        return response_result(ResponseCode.HTTP_SUCCESS, data=result)


    def post(self):
        try:
            json_payload = request.json
            logger.warn(json_payload)
            return response_result(ResponseCode.HTTP_INVAILD_REQUEST)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)


class Batch(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def post(self):
        self.parser.add_argument("ids", type=str, location="args", required=True)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionMenuBatch.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class UpdateSort(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def post(self):
        self.parser.add_argument("id", type=int, location="json", required=True)
        self.parser.add_argument("direction", type=str, choices=["top", "bottom"], location="json", required=True)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionUpdateSort.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class Create(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def post(self):
        self.parser.add_argument("parentId", type=int, location="json", default=None, required=False)
        self.parser.add_argument("icon", type=str, location="json", required=True)
        self.parser.add_argument("path", type=str, location="json", required=True)
        self.parser.add_argument("name", type=str, location="json", required=True)
        self.parser.add_argument("remarks", type=str, location="json", required=True)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionMenuCreate.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            # traceback.print_exc()
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class Treelist(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def post(self):
        self.parser.add_argument("page", type=int, location="args", default=1, required=False)
        self.parser.add_argument("pageSize", type=int, location="args", default=10, required=False)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionTreelist.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class Treenodes(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def get(self):
        self.parser.add_argument("page", type=int, location="args", default=1, required=False)
        self.parser.add_argument("pageSize", type=int, location="args", default=10, required=False)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionTreenodes.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class Updatebyid(Resource):
    def __init__(self):
        self.parser = RequestParser()
        
    def post(self):
        self.parser.add_argument("icon", type=str, location="json", default=None, required=False)
        self.parser.add_argument("name", type=str, location="json", default=None, required=False)
        self.parser.add_argument("parentId", type=int, location="json", default=None, required=False)
        self.parser.add_argument("path", type=str, location="json", default=None, required=False)
        self.parser.add_argument("remark", type=str, location="json", default=None, required=False)
        args = self.parser.parse_args()

        try:
            print("========>", args)
            result, message = signalManager.actionUpdatebyid.emit(args)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

