#!/usr/bin/env python
# -*- coding: utf_8 -*-

import json
from pathlib import Path
from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
from models.monitorEvm import  getListMonitorEvmSchema, getListMonitorEvmsSchema, getMonitorEvmSchema
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result

class NavigationList(Resource):
    def __init__(self):
        self.parser = RequestParser()

    def get(self):
        self.parser.add_argument("page", type=int, location="args", default=1, required=False)
        self.parser.add_argument("pageSize", type=int, location="args", default=15, required=False)
        args = self.parser.parse_args()

        try:
            target_file = Path(__file__).parent.parent.joinpath("hao.360.cn.json")
            data = target_file.read_text()
            data = json.loads(data)
            return response_result(ResponseCode.HTTP_SUCCESS, data=data)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class ApplicationResource(Resource):
    def __init__(self):
        self.parser = RequestParser()

    def get(self, uuid):
        self.parser.add_argument("page", type=int, location="args", default=1)
        self.parser.add_argument("pageSize", type=int, location="args", default=15)
        args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = getMonitorEvmSchema.load(json_payload)
            result, message = signalManager.actionGetMonitorEvm.emit(uuid, data)
            if result:
                json_dumps = getMonitorEvmSchema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

class StoreResource(Resource):
    def __init__(self):
        self.parser = RequestParser()

    def get(self, uuid):
        self.parser.add_argument("page", type=int, location="args", default=1)
        self.parser.add_argument("pageSize", type=int, location="args", default=15)
        args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = getMonitorEvmSchema.load(json_payload)
            result, message = signalManager.actionGetMonitorEvm.emit(uuid, data)
            if result:
                json_dumps = getMonitorEvmSchema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

