#!/usr/bin/env python
# -*- coding: utf_8 -*-

from flask import current_app, jsonify, request
from flask_restful import Resource
from flask_restful.reqparse import RequestParser
from flask_jwt_extended import ( jwt_required, get_jwt_identity )
from application.signal_manager import signalManager
from models.area import  postAreaSchema, deleteAreaSchema, getListAreaSchema, getListAreasSchema, getAreaSchema, putAreaSchema
from webcreator.log import logger
from webcreator.response import ResponseCode, response_result


class AreaResourceList(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    def get(self):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            logger.warn(json_payload)
            data = getListAreaSchema.load(json_payload)
            result, message = signalManager.actionGetlistArea.emit(data)
            json_dumps = getListAreaSchema.dump(result)
            if result:
                json_dumps = getListAreasSchema.dump(result.items)
                logger.warn(json_dumps)
                return response_result(message, data=json_dumps, count=result.total)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)

    @jwt_required(locations=["headers"])
    def post(self):
        try:
            json_payload = request.json
            data = postAreaSchema.load(json_payload)
            result, message = signalManager.actionPostArea.emit(data)
            logger.info(result)
            logger.warn(message)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)


class AreaResource(Resource):
    def __init__(self):
        pass
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser = RequestParser()

    @jwt_required(locations=["headers"])
    def get(self, uuid):
        # 特殊参数，即不是从json获取参数的接口，可以将这个注释打开
        # self.parser.add_argument("page", type=int, location="args", default=1)
        # self.parser.add_argument("pageSize", type=int, location="args", default=15)
        # args = self.parser.parse_args()

        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = getAreaSchema.load(json_payload)
            result, message = signalManager.actionGetArea.emit(uuid, data)
            if result:
                json_dumps = getAreaSchema.dump(result)
                return response_result(message, data=json_dumps)
            return response_result(message)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)


    @jwt_required(locations=["headers"])
    def put(self, uuid):
        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            data = putAreaSchema.load(json_payload)
            result, message = signalManager.actionPutArea.emit(uuid, data)
            logger.info(result)
            logger.info(message)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)


    @jwt_required(locations=["headers"])
    def delete(self, uuid):
        try:
            json_payload = request.json
            print("========>", uuid, json_payload)
            # data = deleteAreaSchema.load(json_payload)
            result, message = signalManager.actionDeleteArea.emit(uuid)
            return response_result(message, data=result)
        except Exception as e:
            current_app.logger.error(e)
            return response_result(ResponseCode.HTTP_SERVER_ERROR)
