#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel
from marshmallow import Schema, fields, INCLUDE, EXCLUDE
from webcreator import utils
from webcreator.log import logger

class UserModel(PrimaryModel):
    __tablename__ = 'evm_user'

    username = db.Column(db.String(70), index = True, nullable = False)
    account = db.Column(db.String(200), nullable = False)
    password = db.Column(db.String(20), nullable = False)
    role = db.Column(db.Integer, nullable = False, default = 0)
    email = db.Column(db.String, nullable = False, default = '')
    phone = db.Column(db.String, nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, username, account, password, role=0, email='', phone=''):
        self.username = username
        self.account = account
        self.password = password
        self.role = role
        self.email = email
        self.phone = phone

    def __setattr__(self, key, value):
        # logger.info(f"execute __setattr__:key={key}, value={value}")
        if key == 'password':
            self.__dict__[key] = utils.md5_encryption(value)
        else:
            self.__dict__[key] = value

    def __repr__(self):
        return '<UserModel %r>' % (self.username)

    def to_dict(self):
        return {
            'username': self.username,
            'account': self.account,
            'password': self.password,
            'role': self.role,
            'email': self.email,
            'phone': self.phone,
        }


class PostUserSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = UserModel

    username = ma.auto_field()
    account = ma.auto_field()
    password = ma.auto_field()

postUserSchema = PostUserSchema()

class DeleteUserSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = UserModel


deleteUserSchema = DeleteUserSchema()

class GetListUserSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = UserModel

    uuid = ma.auto_field()
    username = ma.auto_field()
    account = ma.auto_field()

getListUserSchema = GetListUserSchema()
getListUsersSchema = GetListUserSchema(many=True)

class GetUserSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = UserModel

    username = ma.auto_field()
    account = ma.auto_field()

getUserSchema = GetUserSchema()

class PutUserSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = UserModel

    account = fields.String(required=False, allow_none=True)
    username = fields.String(required=False, allow_none=True)
    password = fields.String(required=False, allow_none=True)

putUserSchema = PutUserSchema()
