#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class PackageModel(PrimaryModel):
    __tablename__ = 'evm_package'

    app = db.Column(db.Integer, nullable = False)
    app_version = db.Column(db.String(200), nullable = False)
    package_info = db.Column(db.String(20), nullable = False)
    algorithm = db.Column(db.String(50), nullable = False, default = 'zlib')
    file_path = db.Column(db.String(200), nullable = False, default = '')
    source = db.Column(db.Integer, nullable = False, default = 0)
    user_agent = db.Column(db.String(200), nullable = False, default = '')
    download_url = db.Column(db.String(200), nullable = False, default = '')
    ip = db.Column(db.String(128), nullable = False, default = '127.0.0.1')
    geo_location = db.Column(db.String(200), nullable = False, default = '')
    operator = db.Column(db.String(50), nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, app, app_version, package_info, algorithm='zlib', file_path='', source=0, user_agent='', download_url='', ip='127.0.0.1', geo_location='', operator='', create_by=None, create_at=None, update_by=None, update_at=None, remarks=""):
        self.app = app
        self.app_version = app_version
        self.package_info = package_info
        self.algorithm = algorithm
        self.file_path = file_path
        self.source = source
        self.user_agent = user_agent
        self.download_url = download_url
        self.ip = ip
        self.geo_location = geo_location
        self.operator = operator
        self.create_by = create_by
        self.create_at = create_at
        self.update_by = update_by
        self.update_at = update_at
        self.remarks = remarks

    def __repr__(self):
        return '<PackageModel %r>' % (self.app)

    def to_dict(self):
        return {
            'uuid': self.uuid,
            'app_version': self.app_version,
            'package_info': self.package_info,
            'algorithm': self.algorithm,
            'file_path': self.file_path,
            'source': self.source,
            'user_agent': self.user_agent,
            'download_url': self.download_url,
            'ip': self.ip,
            'geo_location': self.geo_location,
            'operator': self.operator,
            'remarks': self.remarks,
            "create_at": self.create_at.strftime("%Y-%m-%d %H:%M:%S") if self.create_at else None,
            "update_at": self.update_at.strftime("%Y-%m-%d %H:%M:%S") if self.update_at else None,
        }


class GetListPackageSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = PackageModel

    id = fields.Integer(required=False, nullable=True)
    uuid = fields.String(required=False, nullable=True)
    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    app = fields.String(required=False)
    app_version = ma.auto_field()
    package_info = fields.String(required=False)
    file_path = ma.auto_field()
    source = ma.auto_field()
    user_agent = ma.auto_field()
    download_url = ma.auto_field()
    ip = ma.auto_field()
    geo_location = fields.String(required=False)
    operator = ma.auto_field()

getListPackageSchema = GetListPackageSchema()
getListPackagesSchema = GetListPackageSchema(many=True)

class GetPackageSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = PackageModel

    app = ma.auto_field()
    app_version = ma.auto_field()
    package_info = ma.auto_field()
    file_path = ma.auto_field()
    source = ma.auto_field()
    user_agent = ma.auto_field()
    download_url = ma.auto_field()
    ip = ma.auto_field()
    geo_location = ma.auto_field()
    operator = ma.auto_field()

getPackageSchema = GetPackageSchema()
