#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class MonitorWatchModel(PrimaryModel):
    __tablename__ = 'evm_monitor_watch'

    imei = db.Column(db.String(20), index = True, nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, imei=''):
        self.imei = imei

    def __repr__(self):
        return '<MonitorWatchModel %r>' % (self.imei)

    def to_dict(self):
        return {
            'imei': self.imei,
        }


class GetListMonitorWatchSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorWatchModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    imei = ma.auto_field()

getListMonitorWatchSchema = GetListMonitorWatchSchema()
getListMonitorWatchsSchema = GetListMonitorWatchSchema(many=True)

class GetMonitorWatchSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorWatchModel

    imei = ma.auto_field()

getMonitorWatchSchema = GetMonitorWatchSchema()
