'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-21 18:39:45
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\models\monitorSystem.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class MonitorSystemModel(PrimaryModel):
    __tablename__ = 'evm_monitor_system'

    watch = db.Column(db.Integer, nullable = False)
    free_size = db.Column(db.Integer, nullable = True, default = 0)
    free_space_size = db.Column(db.Integer, nullable = True, default = 0)
    used_space_size = db.Column(db.Integer, nullable = True, default = 0)
    host = db.Column(db.String(20), index = True, nullable = False, default = '')
    path = db.Column(db.String(20), index = True, nullable = False, default = '')
    protocol = db.Column(db.String(20), index = True, nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, watch, free_size=0, free_space_size=0, used_space_size=0, host='', path='', protocol=''):
        self.watch = watch
        self.free_size = free_size
        self.free_space_size = free_space_size
        self.used_space_size = used_space_size
        self.host = host
        self.path = path
        self.protocol = protocol

    def __repr__(self):
        return '<MonitorSystemModel %r>' % (self.watch)

    def to_dict(self):
        return {
            'watch': self.watch,
            'free_size': self.free_size,
            'free_space_size': self.free_space_size,
            'used_space_size': self.used_space_size,
            'host': self.host,
            'path': self.path,
            'protocol': self.protocol,
        }


class GetListMonitorSystemSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorSystemModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    watch = ma.auto_field()

getListMonitorSystemSchema = GetListMonitorSystemSchema()
getListMonitorSystemsSchema = GetListMonitorSystemSchema(many=True)

class GetMonitorSystemSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorSystemModel

    watch = ma.auto_field()

getMonitorSystemSchema = GetMonitorSystemSchema()
