#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class MonitorLvglModel(PrimaryModel):
    __tablename__ = 'evm_monitor_lvgl'

    watch = db.Column(db.Integer, nullable = False)
    total_size = db.Column(db.Integer, nullable = True, default = 0)
    free_cnt = db.Column(db.Integer, nullable = False, default = 0)
    free_size = db.Column(db.Integer, nullable = True, default = 0)
    free_biggest_size = db.Column(db.Integer, nullable = False, default = 0)
    used_cnt = db.Column(db.Integer, nullable = False, default = 0)
    used_pct = db.Column(db.Integer, nullable = False, default = 0)
    frag_pct = db.Column(db.Integer, nullable = False, default = 0)

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, watch, total_size=0, free_cnt=0, free_size=0, free_biggest_size=0, used_cnt=0, used_pct=0, frag_pct=0):
        self.watch = watch
        self.total_size = total_size
        self.free_cnt = free_cnt
        self.free_size = free_size
        self.free_biggest_size = free_biggest_size
        self.used_cnt = used_cnt
        self.used_pct = used_pct
        self.frag_pct = frag_pct

    def __repr__(self):
        return '<MonitorLvglModel %r>' % (self.watch)

    def to_dict(self):
        return {
            'watch': self.watch,
            'total_size': self.total_size,
            'free_cnt': self.free_cnt,
            'free_size': self.free_size,
            'free_biggest_size': self.free_biggest_size,
            'used_cnt': self.used_cnt,
            'used_pct': self.used_pct,
            'frag_pct': self.frag_pct,
        }


class GetListMonitorLvglSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorLvglModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    watch = ma.auto_field()

getListMonitorLvglSchema = GetListMonitorLvglSchema()
getListMonitorLvglsSchema = GetListMonitorLvglSchema(many=True)

class GetMonitorLvglSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorLvglModel

    watch = ma.auto_field()

getMonitorLvglSchema = GetMonitorLvglSchema()
