#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class MonitorImageModel(PrimaryModel):
    __tablename__ = 'evm_monitor_image'

    watch = db.Column(db.Integer, nullable = False)
    length = db.Column(db.Integer, nullable = True, default = 0)
    png_uncompressed_size = db.Column(db.Integer, nullable = False, default = 0)
    png_total_count = db.Column(db.Integer, nullable = True, default = 0)
    png_file_size = db.Column(db.Integer, nullable = True, default = 0)
    uri = db.Column(db.String(20), index = True, nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, watch, length=0, png_uncompressed_size=0, png_total_count=0, png_file_size=0, uri=''):
        self.watch = watch
        self.length = length
        self.png_uncompressed_size = png_uncompressed_size
        self.png_total_count = png_total_count
        self.png_file_size = png_file_size
        self.uri = uri

    def __repr__(self):
        return '<MonitorImageModel %r>' % (self.watch)

    def to_dict(self):
        return {
            'watch': self.watch,
            'length': self.length,
            'png_uncompressed_size': self.png_uncompressed_size,
            'png_total_count': self.png_total_count,
            'png_file_size': self.png_file_size,
            'uri': self.uri,
        }


class GetListMonitorImageSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorImageModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    watch = ma.auto_field()

getListMonitorImageSchema = GetListMonitorImageSchema()
getListMonitorImagesSchema = GetListMonitorImageSchema(many=True)

class GetMonitorImageSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorImageModel

    watch = ma.auto_field()

getMonitorImageSchema = GetMonitorImageSchema()
