#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class MonitorEvmModel(PrimaryModel):
    __tablename__ = 'evm_monitor_evm'

    watch = db.Column(db.Integer, nullable = False)
    heap_map_size = db.Column(db.Integer, nullable = True, default = 0)
    heap_total_size = db.Column(db.Integer, nullable = False, default = 0)
    heap_used_size = db.Column(db.Integer, nullable = True, default = 0)
    stack_total_size = db.Column(db.Integer, nullable = True, default = 0)
    stack_used_size = db.Column(db.Integer, nullable = False, default = 0)

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, watch, heap_map_size=0, heap_total_size=0, heap_used_size=0, stack_total_size=0, stack_used_size=0):
        self.watch = watch
        self.heap_map_size = heap_map_size
        self.heap_total_size = heap_total_size
        self.heap_used_size = heap_used_size
        self.stack_total_size = stack_total_size
        self.stack_used_size = stack_used_size

    def __repr__(self):
        return '<MonitorEvmModel %r>' % (self.watch)

    def to_dict(self):
        return {
            'watch': self.watch,
            'heap_map_size': self.heap_map_size,
            'heap_total_size': self.heap_total_size,
            'heap_used_size': self.heap_used_size,
            'stack_total_size': self.stack_total_size,
            'stack_used_size': self.stack_used_size,
        }


class GetListMonitorEvmSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorEvmModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    watch = ma.auto_field()

getListMonitorEvmSchema = GetListMonitorEvmSchema()
getListMonitorEvmsSchema = GetListMonitorEvmSchema(many=True)

class GetMonitorEvmSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = MonitorEvmModel

    watch = ma.auto_field()

getMonitorEvmSchema = GetMonitorEvmSchema()
