#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class DeviceModel(PrimaryModel):
    __tablename__ = 'evm_device'

    imei = db.Column(db.String(20), index = True, nullable = False)
    name = db.Column(db.String(20), index = True, nullable = False, default = '')
    type = db.Column(db.String(20), nullable = False, default = '')
    desc = db.Column(db.String(20), index = True, nullable = False, default = '')

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, imei, name='', type='', desc='', create_by=None, create_at=None, update_by=None, update_at=None, remarks=""):
        self.imei = imei
        self.name = name
        self.type = type
        self.desc = desc
        self.create_by = create_by
        self.create_at = create_at
        self.update_by = update_by
        self.update_at = update_at
        self.remarks = remarks

    def __repr__(self):
        return '<DeviceModel %r>' % (self.imei)

    def to_dict(self):
        return {
            'uuid': self.uuid,
            'imei': self.imei,
            'name': self.name,
            'type': self.type,
            'desc': self.desc,
            "create_by": self.create_by,
            "update_by": self.update_by,
            "create_at": self.create_at.strftime("%Y-%m-%d %H:%M:%S") if self.create_at else None,
            "update_at": self.update_at.strftime("%Y-%m-%d %H:%M:%S") if self.update_at else None,
        }


class PostDeviceSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = DeviceModel

    imei = ma.auto_field()
    name = ma.auto_field()
    type = ma.auto_field()
    desc = ma.auto_field()

postDeviceSchema = PostDeviceSchema()

class DeleteDeviceSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = DeviceModel


deleteDeviceSchema = DeleteDeviceSchema()

class GetListDeviceSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = DeviceModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    uuid = ma.auto_field()
    imei = ma.auto_field()
    name = ma.auto_field()
    type = ma.auto_field()
    desc = ma.auto_field()
    create_at = ma.auto_field()
    update_at = ma.auto_field()

getListDeviceSchema = GetListDeviceSchema()
getListDevicesSchema = GetListDeviceSchema(many=True)

class GetDeviceSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = DeviceModel

    imei = ma.auto_field()
    name = ma.auto_field()
    type = ma.auto_field()

getDeviceSchema = GetDeviceSchema()

class PutDeviceSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = DeviceModel

    imei = fields.String(required=False, length=None)
    name = fields.String(required=False, length=None)
    type = fields.String(required=False, length=None)
    desc = fields.String(required=False, length=None)

putDeviceSchema = PutDeviceSchema()
