'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-28 09:38:58
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\models\base.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

import uuid
from datetime import datetime
from application.app import db

def generate_uuid():
    return uuid.uuid1().hex

class BaseModel(db.Model):
    # Flask-SQLAlchemy创建table时,如何声明基类（这个类不会创建表,可以被继承）
    # 方法就是把__abstract__这个属性设置为True,这个类为基类，不会被创建为表！
    __abstract__ = True
    create_at = db.Column(db.DateTime, default=datetime.now)
    create_by = db.Column(db.String(64))
    update_at = db.Column(db.DateTime, default=datetime.now)
    update_by = db.Column(db.String(64))
    remarks = db.Column(db.String(255), default="")
    is_delete = db.Column(db.BOOLEAN, default=0)

class PrimaryModel(BaseModel):
    __abstract__ = True
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    uuid = db.Column(db.String(64), primary_key=False, default=generate_uuid)
    sort = db.Column(db.Integer, default=0)

class AutoBaseModel(BaseModel):
    __abstract__ = True
    id = db.Column(db.Integer, primary_key=True, autoincrement=True)
    sort = db.Column(db.Integer, default=0)

class UuidBaseModel(BaseModel):
    __abstract__ = True
    id = db.Column(db.String(64), primary_key=True, default=generate_uuid)
    sort = db.Column(db.Integer, default=0)

class SortBaseModel(BaseModel):
    __abstract__ = True
    sort = db.Column(db.Integer, default=0)