#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class AreaModel(PrimaryModel):
    __tablename__ = 'evm_area'

    areaCode = db.Column(db.String(20), index = True, nullable = False, default = '')
    areaName = db.Column(db.String(20), index = True, nullable = False, default = '')
    level = db.Column(db.Integer, nullable = False, default = 1)
    cityCode = db.Column(db.Integer, nullable = True, default = 0)
    center = db.Column(db.String(20), index = True, nullable = False, default = '')
    parentId = db.Column(db.String(20), nullable = True, default = '')
    hasChildren = db.Column(db.Boolean, nullable = True, default = False)

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, areaCode='', areaName='', level=1, cityCode=0, center='', parentId='', hasChildren=False):
        self.areaCode = areaCode
        self.areaName = areaName
        self.level = level
        self.cityCode = cityCode
        self.center = center
        self.parentId = parentId
        self.hasChildren = hasChildren

    def __repr__(self):
        return '<AreaModel %r>' % (self.areaCode)

    def to_dict(self):
        return {
            'areaCode': self.areaCode,
            'areaName': self.areaName,
            'level': self.level,
            'cityCode': self.cityCode,
            'center': self.center,
            'parentId': self.parentId,
            'hasChildren': self.hasChildren,
        }

class PostAreaSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AreaModel

    areaCode = ma.auto_field()
    areaName = ma.auto_field()
    level = ma.auto_field()
    parentId = ma.auto_field()
    hasChildren = ma.auto_field()
    cityCode = ma.auto_field()
    center = ma.auto_field()

postAreaSchema = PostAreaSchema()

class DeleteAreaSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AreaModel


deleteAreaSchema = DeleteAreaSchema()

class GetlistAreaSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AreaModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    areaName = ma.auto_field()
    level = ma.auto_field()
    parentId = ma.auto_field()
    hasChildren = ma.auto_field()
    field = fields.String(required=False, length=None)

getListAreaSchema = GetlistAreaSchema()
getListAreasSchema = GetlistAreaSchema(many=True)

class GetAreaSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AreaModel

    areaName = ma.auto_field()
    level = ma.auto_field()
    parentId = ma.auto_field()
    hasChildren = ma.auto_field()
    field = fields.String(required=False, length=None)

getAreaSchema = GetAreaSchema()

class PutAreaSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AreaModel

    areaName = fields.String(required=False, length=None)
    level = fields.Integer(required=False)
    parentId = fields.String(required=False, length=None)
    hasChildren = fields.Boolean(required=False)
    field = fields.String(required=False, length=None)

putAreaSchema = PutAreaSchema()
