# -*- coding: utf-8 -*-

from application.app import db, ma
from .base import PrimaryModel
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class AppModel(PrimaryModel):
    __tablename__ = 'evm_app'

    app_name = db.Column(db.String(70), index = True, nullable = False)
    app_icon = db.Column(db.String(200), nullable = False)
    app_version = db.Column(db.String(20), nullable = False)
    category = db.Column(db.String(50), nullable = False)
    launcher = db.Column(db.String(50), nullable = False)
    developer = db.Column(db.String(50), nullable = False)
    download_url = db.Column(db.String(200), nullable = False, default = '')
    app_file_size = db.Column(db.Integer, nullable = False)
    app_screen_size = db.Column(db.String(20), nullable = False)
    app_arch = db.Column(db.String(20), nullable = False, default = '')
    app_review = db.Column(db.Integer, nullable = False, default = 0)
    meta_data = db.Column(db.String(256), nullable = True)

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, app_name, app_icon, app_version, category='', launcher='', developer=0, download_url='', meta_data='', app_file_size=0, app_screen_size='', app_arch='', app_review=0, create_by=None, create_at=None, update_by=None, update_at=None, remarks=""):
        self.app_name = app_name
        self.app_icon = app_icon
        self.app_version = app_version
        self.category = category
        self.launcher = launcher
        self.developer = developer
        self.download_url = download_url
        self.app_file_size = app_file_size
        self.app_screen_size = app_screen_size
        self.app_arch = app_arch
        self.app_review = app_review
        self.meta_data = meta_data
        self.create_by = create_by
        self.create_at = create_at
        self.update_by = update_by
        self.update_at = update_at
        self.remarks = remarks

    def __repr__(self):
        return '<AppModel %r>' % (self.app_name)

    def to_dict(self):
        return {
            'uuid': self.uuid,
            'app_name': self.app_name,
            'app_icon': self.app_icon,
            'app_version': self.app_version,
            'category': self.category,
            'launcher': self.launcher,
            'developer': self.developer,
            'download_url': self.download_url,
            'app_file_size': self.app_file_size,
            'app_screen_size': self.app_screen_size,
            'app_arch': self.app_arch,
            'meta_data': self.meta_data,
            'app_review': self.app_review,
            'remarks': self.remarks,
            "create_by": self.create_by,
            "update_by": self.update_by,
            "create_at": self.create_at.strftime("%Y-%m-%d %H:%M:%S") if self.create_at else None,
            "update_at": self.update_at.strftime("%Y-%m-%d %H:%M:%S") if self.update_at else None,
        }


class PostAppSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AppModel

    meta_data = fields.String(required=False)
    app_name = ma.auto_field()
    app_icon = fields.String(required=False)
    app_version = ma.auto_field()
    category = ma.auto_field()
    launcher = fields.String(required=False)
    developer = fields.String(required=False)
    app_screen_size = ma.auto_field()
    app_arch = ma.auto_field()
    app_review = ma.auto_field(required=False)
    remarks = fields.String(required=False)
    logo = fields.Raw(required=False)
    fileList = fields.Raw(required=False)

postAppSchema = PostAppSchema()

class DeleteAppSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AppModel


deleteAppSchema = DeleteAppSchema()

class GetListAppSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AppModel

    uuid = fields.String(required=False, nullable=True)
    page = fields.Integer(required=False, default=1, nullable=True)
    pageSize = fields.Integer(required=False, default=15, nullable=True)
    scope = fields.String(required=False, nullable=True)
    app_name = fields.String(required=False, nullable=True)
    app_icon = fields.String(required=False, nullable=True)
    app_version = fields.String(required=False, nullable=True)
    algorithm = fields.String(required=False, nullable=True)
    category = fields.String(required=False, nullable=True)
    launcher = fields.String(required=False, nullable=True)
    app_arch = fields.String(required=False, nullable=True)
    meta_data = fields.String(required=False, nullable=True)
    download_url = fields.String(required=False, nullable=True)
    app_file_size = fields.Integer(required=False, nullable=True)
    app_screen_size = fields.String(required=False, nullable=True)
    app_review = fields.Integer(required=False, nullable=True)
    create_at = fields.DateTime(required=False, nullable=True)
    update_at = fields.DateTime(required=False, nullable=True)
    remarks = fields.String(required=False)

getListAppSchema = GetListAppSchema()
getListAppsSchema = GetListAppSchema(many=True)

class GetAppSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AppModel

    id = fields.Integer(required=False, nullable=True)
    uuid = fields.String(required=False, nullable=True)
    app_name = fields.String(required=False, nullable=True)
    app_icon = fields.String(required=False, nullable=True)
    app_version = fields.String(required=False, nullable=True)
    algorithm = fields.String(required=False, nullable=True)
    category = fields.String(required=False, nullable=True)
    launcher = fields.String(required=False, nullable=True)
    app_arch = fields.String(required=False, nullable=True)
    meta_data = fields.String(required=False, nullable=True)
    download_url = fields.String(required=False, nullable=True)
    app_file_size = fields.Integer(required=False, nullable=True)
    app_screen_size = fields.String(required=False, nullable=True)
    app_review = fields.Integer(required=False, nullable=True)
    create_at = fields.DateTime(required=False, nullable=True)
    update_at = fields.DateTime(required=False, nullable=True)
    remarks = fields.String(required=False)

getAppSchema = GetAppSchema()

class PutAppSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AppModel

    app_name = fields.String(required=False, nullable=True)
    app_icon = fields.String(required=False, nullable=True)
    app_version = fields.String(required=False, nullable=True)
    category = fields.String(required=False, nullable=True)
    launcher = fields.String(required=False, nullable=True)
    app_arch = fields.String(required=False, nullable=True)
    download_url = fields.String(required=False, nullable=True)
    app_file_size =  fields.Integer(required=False, nullable=True)
    app_screen_size =  fields.String(required=False, nullable=True)
    meta_data = fields.String(required=False, nullable=True)
    app_review = fields.Integer(required=False, nullable=True)
    remarks = fields.String(required=False, nullable=True)

putAppSchema = PutAppSchema()
