#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.app import db, ma
from .base import PrimaryModel 
from marshmallow import Schema, fields, INCLUDE, EXCLUDE

class AnnexModel(PrimaryModel):
    __tablename__ = 'evm_annex'

    app = db.Column(db.Integer, nullable = False)
    title = db.Column(db.String(100), index = True, nullable = False, default = '')
    path = db.Column(db.String(256), index = True, nullable = False, default = '')
    size = db.Column(db.Integer, nullable = True, default = 0)

    # __table_args__ = (
    #     db.Index('idx_xxx', 'xxx', mysql_using='btree'),
    # )

    def __init__(self, app, title='', path='', size=0):
        self.app = app
        self.title = title
        self.path = path
        self.size = size

    def __repr__(self):
        return '<AnnexModel %r>' % (self.app)

    def to_dict(self):
        return {
            'app': self.app,
            'title': self.title,
            'path': self.path,
            'size': self.size,
        }

class DeleteAnnexSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AnnexModel


deleteAnnexSchema = DeleteAnnexSchema()

class GetlistAnnexSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AnnexModel

    page = fields.Integer(required=False)
    pageSize = fields.Integer(required=False)
    title = ma.auto_field()
    app = ma.auto_field()

getListAnnexSchema = GetlistAnnexSchema()
getListAnnexsSchema = GetlistAnnexSchema(many=True)

class GetAnnexSchema(ma.SQLAlchemySchema):
    class Meta:
        # unknown = INCLUDE # 未知字段默认包含
        unknown = EXCLUDE # 未知字段默认排除
        model = AnnexModel

    app = ma.auto_field()

getAnnexSchema = GetAnnexSchema()
