'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-28 15:29:13
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\models\__init__.py
'''
'''
Author: your name
Date: 2021-04-22 18:04:10
LastEditTime: 2021-07-27 20:04:43
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\resources\models\__init__.py
'''
# -*- coding: utf-8 -*-
from sqlalchemy import create_engine
from sqlalchemy import Column, Integer, String
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declared_attr, declarative_base
from application.app import config

class BaseModelMixin(object):
    @declared_attr
    def __tablename__(self):
        return self.__name__.lower()

    # __table_args__ = {'mysql_engine': 'InnoDB'}
    __mapper_args__= {'always_refresh': True}
    id = Column(Integer, primary_key=True)

BaseModel = declarative_base(cls=BaseModelMixin)

class MyModel(BaseModel, BaseModelMixin):
    __tablename__ = 'evm_store_app_logs'
    app_name = Column(String(20))
    app_path = Column(String(32))
    app_version = Column(String(32))
    app_info = Column(String(32))
    create_at = Column(String(32))
    create_by = Column(Integer())

class MyModel2(BaseModel, BaseModelMixin):
    __tablename__ = 'monitor_request'
    host = Column(String(32))
    path = Column(String(32))
    protocol = Column(String(32))
    create_at = Column(String(32))

# if __name__ == "__main__":
engine = create_engine(config.SQLALCHEMY_DATABASE_URI)

BaseModel.metadata.create_all(engine, checkfirst=True)

Session = sessionmaker(bind=engine)
session = Session()

# ed_user = MyModel(name='ed', fullname='Ed Jones', password='edspassword')
# session.add(ed_user)

# session.add_all(
#     [
#         MyModel(name='wendy', fullname='Wendy Williams', password='foobar'),
#         MyModel(name='mary', fullname='Mary Contrary', password='xxg527'),
#         MyModel(name='fred', fullname='Fred Flinstone', password='blah')
#     ]
# )
# session.commit()

# our_user = session.query(MyModel).filter_by(name='ed').first()
# print(our_user)
