'''
Author: your name
Date: 2021-07-22 04:03:24
LastEditTime: 2021-07-23 00:51:58
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\controllers\workbench.py
'''
import datetime
from models.user import UserModel
from models.device import DeviceModel
from models.app import AppModel
from models.package import PackageModel
from webcreator.log import logger
from webcreator.response import ResponseCode

# 今日上传应用数 、历史应用总数
# 今日打包次数、历史打包总数
# 今日新增设备数，绑定设备数
# 今日新增开发者，开发者总数

'''
time_now = datetime.now()
#最近30天数据
result = UserModel.query.filter(UserModel.create_time >= time_now - timedelta(days=30)).all()
#最近一周数据
result = UserModel.query.filter(UserModel.create_time >= time_now - timedelta(days=7)).all()
#最近1天数据
result = UserModel.query.filter(UserModel.create_time >= time_now - timedelta(days=1)).all()
#最近12小时
result = UserModel.query.filter(UserModel.create_time >= time_now - timedelta(hours=12)).all()
#最近半小时
result = UserModel.query.filter(UserModel.create_time >= time_now - timedelta(seconds=30)).all()
'''


class WorkbenchResource(object):
    def __init__(self):
        super().__init__()

    def get(self, jwt={}):
        if not jwt:
            return None, ResponseCode.HTTP_INVAILD_REQUEST

        user = UserModel.query.filter(UserModel.uuid==jwt.get("uuid")).one_or_none()
        if not user:
            return None, ResponseCode.USER_NOT_EXISTS

        today = datetime.date.today()
        tomorrow = today + datetime.timedelta(days=1)

        logger.info(user.role)

        if user.role == 1:
            total_user = UserModel.query.filter().count()
            today_user = UserModel.query.filter(UserModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), UserModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_device = DeviceModel.query.filter().count()
            today_device = DeviceModel.query.filter(DeviceModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), DeviceModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_app = AppModel.query.filter().count()
            today_app = AppModel.query.filter(AppModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), AppModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_package = PackageModel.query.filter().count()
            today_package = PackageModel.query.filter(PackageModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), PackageModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()
        else:
            total_user = UserModel.query.filter(UserModel.create_by==user.id).count()
            today_user = UserModel.query.filter(UserModel.create_by==user.id, UserModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), UserModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_device = DeviceModel.query.filter(DeviceModel.create_by==user.id).count()
            today_device = DeviceModel.query.filter(DeviceModel.create_by==user.id, DeviceModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), DeviceModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_app = AppModel.query.filter(AppModel.create_by==user.id).count()
            today_app = AppModel.query.filter(AppModel.create_by==user.id, AppModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), AppModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

            total_package = PackageModel.query.filter(PackageModel.create_by==user.id).count()
            today_package = PackageModel.query.filter(PackageModel.create_by==user.id, PackageModel.create_at >= today.strftime("%Y-%m-%d 00:00:00"), PackageModel.create_at <= tomorrow.strftime("%Y-%m-%d 00:00:00")).count()

        result = {
            'total_user': total_user,
            'today_user': today_user,
            'total_device': total_device,
            'today_device': today_device,
            'total_app': total_app,
            'today_app': today_app,
            'total_package': total_package,
            'today_package': today_package
        }

        logger.info(result)

        return result, ResponseCode.HTTP_SUCCESS


workbenchResource = WorkbenchResource()