'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-22 10:35:53
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\controllers\device.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

from datetime import datetime
from application.app import db
from models.user import UserModel
from models.device import DeviceModel
from webcreator.log import logger
from webcreator.response import ResponseCode

class DeviceResource(object):
    def __init__(self):
        super().__init__()

    def get(self, uuid, params):
        # handle business
        filters = [DeviceModel.is_delete==False, DeviceModel.uuid==uuid]
        result = DeviceModel.query.filter(*filters).first()
        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def getList(self, params, jwt={}):
        # handle business
        user = UserModel.query.filter(UserModel.uuid==jwt.get("uuid"), UserModel.is_delete==False).one_or_none()
        if not user:
            return False, ResponseCode.USER_NOT_EXISTS

        filters = [DeviceModel.is_delete==False, DeviceModel.create_by==user.id]
        if params.get("type"): filters.append(DeviceModel.type==params.get("type"))
        if params.get("name"): filters.append(DeviceModel.name==params.get("name"))
        if params.get("imei"): filters.append(DeviceModel.imei==params.get("imei"))
        result = DeviceModel.query.filter(*filters).order_by(DeviceModel.create_at).paginate(params.get('page', 1), params.get('pageSize', 10), error_out=False)

        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def post(self, params, jwt={}):
        # handle business
        result = DeviceModel.query.filter(DeviceModel.imei == params.get('imei')).first()
        if result and result.is_delete:
            result.is_delete = False
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        elif result and result.is_delete == False:
            return False, ResponseCode.IMEI_EXISTS

        user = UserModel.query.filter(UserModel.uuid==jwt.get("uuid")).one_or_none()
        if not user:
            return False, ResponseCode.USER_NOT_EXISTS

        params.update({
            'create_at': datetime.now(),
            'create_by': user.id,
            'update_at': datetime.now(),
            'update_by': user.id
        })
        result = DeviceModel(**params)
        db.session.add(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS

    def put(self, uuid, params, jwt={}):
        # handle business
        result = DeviceModel.query.filter(DeviceModel.uuid==uuid).first()
        if not result:
            return None, ResponseCode.HTTP_NOT_FOUND

        if params:
            for key, value in params.items():
                if value != None: setattr(result, key, value)
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        else:
            return False, ResponseCode.HTTP_INVAILD_REQUEST

    def delete(self, uuid, jwt={}):
        # handle business
        result = DeviceModel.query.filter(DeviceModel.uuid==uuid).first()
        if not result:
            return False, ResponseCode.HTTP_NOT_FOUND

        result.update_by = jwt.get("id", "")
        result.update_date = datetime.now()
        result.is_delete = True
        db.session.delete(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS

deviceManager = DeviceResource()