#!/usr/bin/env python
# -*- coding: utf_8 -*-

from datetime import datetime
from application.app import db
from models.annex import AnnexModel
from webcreator.log import logger
from webcreator.response import ResponseCode

class AnnexResource(object):
    def __init__(self):
        super().__init__()


    def get(self, uuid, params):
        # handle business
        filters = [AnnexModel.is_delete==False, AnnexModel.uuid==uuid]
        result = AnnexModel.query.filter(*filters).first()
        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def getList(self, params):
        # handle business
        logger.warn(params)
        filters = [AnnexModel.is_delete==False]
        result = AnnexModel.query.filter(*filters).order_by(AnnexModel.create_at).paginate(params.get('page', 1), params.get('pageSize', 10), error_out=False)

        if result:
            return result, ResponseCode.HTTP_SUCCESS
        return None, ResponseCode.HTTP_NOT_FOUND

    def post(self, params, jwt={}):
        # handle business
        result = AnnexModel.query.filter(AnnexModel.app == params.get('app')).first()
        if result and result.is_delete:
            result.is_delete = False
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        elif result and result.is_delete == False:
            return False, ResponseCode.HTTP_INVAILD_REQUEST

        result = AnnexModel(**params)
        db.session.add(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS

    def put(self, uuid, params, jwt={}):
        # handle business
        result = AnnexModel.query.filter(AnnexModel.uuid==uuid).first()
        if not result:
            return None, ResponseCode.HTTP_NOT_FOUND

        if params:
            for key, value in params.items():
                if value != None: setattr(result, key, value)
            result.update_by = jwt.get("id", "")
            result.update_date = datetime.now()
            db.session.commit()
            return True, ResponseCode.HTTP_SUCCESS
        else:
            return False, ResponseCode.HTTP_INVAILD_REQUEST

    def delete(self, uuid, jwt={}):
        # handle business
        result = AnnexModel.query.filter(AnnexModel.uuid==uuid).first()
        if not result:
            return False, ResponseCode.HTTP_NOT_FOUND

        result.update_by = jwt.get("id", "")
        result.update_date = datetime.now()
        result.is_delete = True
        db.session.delete(result)
        db.session.commit()
        return True, ResponseCode.HTTP_SUCCESS


annexManager = AnnexResource()