'''
Author: your name
Date: 2021-07-15 09:33:39
LastEditTime: 2021-07-28 17:07:05
LastEditors: your name
Description: In User Settings Edit
FilePath: \evm-store\tools\build_out\controllers\__init__.py
'''
#!/usr/bin/env python
# -*- coding: utf_8 -*-

from application.signal_manager import signalManager
from .area import areaManager
from .app import appManager
from .package import packageManager
from .user import userManager
from .login import loginManager
from .device import deviceManager
from .annex import annexManager
from .monitorWatch import monitorWatchManager
from .monitorSystem import monitorSystemManager
from .monitorLvgl import monitorLvglManager
from .monitorImage import monitorImageManager
from .monitorEvm import monitorEvmManager
from .menu import menuManager
from .api import appReview, buildAppResource
from .file import fileManager
from .workbench import workbenchResource

def initConnect():
    signalManager.actionPostArea.connect(areaManager.post)
    signalManager.actionDeleteArea.connect(areaManager.delete)
    signalManager.actionGetlistArea.connect(areaManager.getList)
    signalManager.actionGetArea.connect(areaManager.get)
    signalManager.actionPutArea.connect(areaManager.put)
    signalManager.actionPostApp.connect(appManager.post)
    signalManager.actionDeleteApp.connect(appManager.delete)
    signalManager.actionGetlistApp.connect(appManager.getList)
    signalManager.actionGetApp.connect(appManager.get)
    signalManager.actionPutApp.connect(appManager.put)
    signalManager.actionGetlistPackage.connect(packageManager.getList)
    signalManager.actionGetPackage.connect(packageManager.get)
    signalManager.actionPostUser.connect(userManager.post)
    signalManager.actionDeleteUser.connect(userManager.delete)
    signalManager.actionGetlistUser.connect(userManager.getList)
    signalManager.actionGetUser.connect(userManager.get)
    signalManager.actionPutUser.connect(userManager.put)
    signalManager.actionPostLogin.connect(loginManager.post)
    signalManager.actionGetlistLogin.connect(loginManager.getList)
    signalManager.actionGetLogin.connect(loginManager.get)
    signalManager.actionPostDevice.connect(deviceManager.post)
    signalManager.actionDeleteDevice.connect(deviceManager.delete)
    signalManager.actionGetlistDevice.connect(deviceManager.getList)
    signalManager.actionGetDevice.connect(deviceManager.get)
    signalManager.actionPutDevice.connect(deviceManager.put)
    signalManager.actionDeleteAnnex.connect(annexManager.delete)
    signalManager.actionGetlistAnnex.connect(annexManager.getList)
    signalManager.actionGetAnnex.connect(annexManager.get)
    signalManager.actionGetlistMonitorwatch.connect(monitorWatchManager.getList)
    signalManager.actionGetMonitorwatch.connect(monitorWatchManager.get)
    signalManager.actionGetlistMonitorsystem.connect(monitorSystemManager.getList)
    signalManager.actionGetMonitorsystem.connect(monitorSystemManager.get)
    signalManager.actionGetlistMonitorlvgl.connect(monitorLvglManager.getList)
    signalManager.actionGetMonitorlvgl.connect(monitorLvglManager.get)
    signalManager.actionGetlistMonitorimage.connect(monitorImageManager.getList)
    signalManager.actionGetMonitorimage.connect(monitorImageManager.get)
    signalManager.actionGetlistMonitorevm.connect(monitorEvmManager.getList)
    signalManager.actionGetMonitorevm.connect(monitorEvmManager.get)
    signalManager.actionTreelist.connect(menuManager.treeList)
    signalManager.actionTreenodes.connect(menuManager.treeNodes)
    signalManager.actionUpdatebyid.connect(menuManager.updateById)
    signalManager.actionMenuCreate.connect(menuManager.create)
    signalManager.actionUpdateSort.connect(menuManager.updateSort)
    signalManager.actionMenuBatch.connect(menuManager.batch)
    # file manager api
    signalManager.actionGetFileContent.connect(fileManager.content)
    signalManager.actionGetFileDisk.connect(fileManager.disk)
    signalManager.actionGetFileDown.connect(fileManager.download)
    signalManager.actionGetFileInit.connect(fileManager.initialize)
    signalManager.actionGetFilePreview.connect(fileManager.preview)
    signalManager.actionGetFileTree.connect(fileManager.tree)
    signalManager.actionPostFileUpdate.connect(fileManager.update_file)
    signalManager.actionPostFileUpload.connect(fileManager.upload)
    signalManager.actionPostFileDelete.connect(fileManager.delete)
    signalManager.actionPostFileCreate.connect(fileManager.create_file)
    signalManager.actionPostFileCreateDir.connect(fileManager.create_dir)
    signalManager.actionPostFilePaste.connect(fileManager.paste)
    # api
    signalManager.actionPostAppReview.connect(appReview.post)
    signalManager.actionSetLauncher.connect(appReview.get)
    signalManager.actionGetLauncher.connect(appReview.getLauncher)
    signalManager.actionApplicationBuild.connect(buildAppResource.post)
    signalManager.actionGetAppList.connect(appReview.getAppList)
    signalManager.actionGetApplication.connect(appReview.getApp)
    signalManager.actionGetEpk.connect(appReview.getDownloadFile)
    signalManager.actionCheckVersion.connect(appReview.checkAppVersion)
    signalManager.actionWorkbench.connect(workbenchResource.get)
