/*
 * @Author: your name
 * @Date: 2021-04-14 14:12:19
 * @LastEditTime: 2021-07-01 02:12:04
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \evm-store\frontend\src\utils\utils.js
 */
function formatNumber(n) {
    n = n.toString();
    return n[1] ? n : "0" + n;
}

export function getDateTime(datetime) {
    var year = datetime.getFullYear();
    var month = datetime.getMonth() + 1;
    var day = datetime.getDate();
    var hour = datetime.getHours();
    var minute = datetime.getMinutes();
    var second = datetime.getSeconds();
    return [year, month, day, hour, minute, second].map(formatNumber);
}

export function formatDateTime(
    datetime = [],
    format = ["-", "-", " ", ":", ":"]
) {
    let result = "";
    datetime.forEach((d, i) => {
        result += i < 5 ? d + format[i] : d;
    });
    return result;
}

export function getDateTimeString(datetime) {
    if (!(datetime instanceof Date)) datetime = new Date(datetime);
    datetime = getDateTime(datetime);
    const format = ["-", "-", " ", ":", ":"];
    let result = "";
    datetime.forEach((d, i) => {
        result += i < 5 ? d + format[i] : d;
    });
    return result;
}
