/*
 * @Author: your name
 * @Date: 2021-07-15 09:33:39
 * @LastEditTime: 2021-07-15 19:07:35
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: \evm-store\tools\frontend\src\store\index.js
 */
import Vue from 'vue'
import Vuex from 'vuex'

import fm from './file-manager'
import global from './modules/global'
import globalNav from './modules/global-nav'
import frontendLogin from './modules/frontend-login'
import frontendOpenapi from './modules/frontend-openapi'

Vue.use(Vuex)

export default new Vuex.Store({
  modules: {
    fm,
    frontend: {
      namespaced: true,
      modules: {
        openapi: frontendOpenapi,
        login: frontendLogin
      }
    },
    global: {
      namespaced: true,
      ...global,
      modules: {
        nav: globalNav
      }
    }
  },
})
