import "./UserLayout.less";
import logo from "@/assets/app-store.svg";
import { mapGetters } from "vuex";
const UserLayout = {
  props: {
    logo: { default: logo, types: String },
  },
  computed: {
    ...mapGetters({
      settings: "global/settings",
    }),
  },
  render() {
    const { leftMenuTitle, appSlogan } = this.settings;

    return (
      <div class="ai-user-layout-container">
        <div class="content">
          <div class="top">
            <div class="header">
              <img alt="logo" class="logo" src={this.logo} />
              <span class="title">{leftMenuTitle}</span>
            </div>
            <div class="desc">{appSlogan}</div>
          </div>
          <router-view />
        </div>
      </div>
    );
  },
};
export default UserLayout;
