import "./index.less";
import ThemeColor from "./ThemeColor";
import BlockChecbox from "./BlockChecbox";
import Vue from 'vue';
import { Drawer, Modal, Divider, Switch, Radio, message } from "ant-design-vue";
import { mapGetters } from "vuex";

const Body = {
  props: ["title"],
  render: function render() {
    var h = arguments[0];
    const { $slots, title } = this;
    return h("div", { style: { marginBottom: 24 } }, [
      h("h3", { class: "title" }, title),
      $slots["default"],
    ]);
  },
};

Vue.use(Drawer)
Vue.use(Modal)
Vue.use(Switch)
Vue.use(Radio)

const SettingDrawer = {
  // data: () => ({
  //     primaryColor: "#42b983",
  //     blockChecbox: "sidemenu"
  // }),
  props: ["collapse"],
  computed: {
    ...mapGetters({
      settings: "global/settings",
    }),
  },
  methods: {
    changeSetting(key, value) {
      const nextState = this.settings;
      nextState[key] = value;

      if (key === "layout") {
        nextState.contentWidth = value === "topmenu" ? "Fixed" : "Fluid";
      }
      else if (key === 'fixedHeader' && !value) {
        nextState.autoHideHeader = false;
      }
      // console.log(this.settings);
      // console.log(nextState);

      nextState.config = true;
      this.$store.commit('global/UpdateDefaultSettings', this.settings);
      this.$store.commit('global/UpdateDefaultSettings', nextState);
      message.loading("正在编译主题！", 1.5);
      this.$store.dispatch("global/defaultSettings", true);

    },
    onChange(checked) {
      console.log(`a-switch to ${checked}`);
    },
    togglerContent() {
      this.$parent.collapse = !this.collapse;
    },
  },
  render() {
    const { collapse } = this;
    const { primaryColor, layout, navTheme, contentWidth, fixedHeader, fixSiderbar, autoHideHeader } = this.settings;

    return (
      <Drawer
        title="界面设置"
        placement="right"
        closable={false}
        onClose={this.togglerContent}
        visible={collapse}
        width={300}
      >
        <div class="setting-drawer content">
          <Body title={this.$t("app.setting.pagestyle")}>
            <BlockChecbox
              list={[
                {
                  key: "dark",
                  url:
                    "https://gw.alipayobjects.com/zos/rmsportal/LCkqqYNmvBEbokSDscrm.svg",
                  title: this.$t("app.setting.pagestyle.dark"),
                },
                {
                  key: "light",
                  url:
                    "https://gw.alipayobjects.com/zos/rmsportal/jpRkZQMyYRryryPNtyIC.svg",
                  title: this.$t("app.setting.pagestyle.light"),
                },
              ]}
              value={navTheme}
              onChange={(e) => {
                this.changeSetting("navTheme", e);
              }}
            />
          </Body>
          <Divider />
          <ThemeColor
            title={this.$t("app.setting.themecolor")}
            value={primaryColor}
            onChange={(e) => {
              this.changeSetting("primaryColor", e);
            }}
          />

          <Divider />

          <Body title={this.$t("app.setting.navigationmode")}>
            <BlockChecbox
              list={[
                {
                  key: "sidemenu",
                  url:
                    "https://gw.alipayobjects.com/zos/rmsportal/JopDzEhOqwOjeNTXkoje.svg",
                  title: this.$t("app.setting.sidemenu"),
                },
                {
                  key: "topmenu",
                  url:
                    "https://gw.alipayobjects.com/zos/rmsportal/KDNDBbriJhLwuqMoxcAr.svg",
                  title: this.$t("app.setting.topmenu"),
                  style: { paddingLeft: "18px" },
                },
              ]}
              value={layout}
              onChange={(e) => {
                this.changeSetting("layout", e);
              }}
            />
          </Body>

          <Divider />
          <h3 class="setting-title">其它设置</h3>
          <div class="setting-item">
            <p>内容区域宽度</p>
            <a-radio-group value={contentWidth} size="small" default-value="Fluid" button-style="solid" onChange={(e) => {
              this.changeSetting("contentWidth", e.target.value);
            }}>
              <a-radio-button value="Fluid">
                流式
              </a-radio-button>
              <a-radio-button value="Fixed">
                固定
              </a-radio-button>
            </a-radio-group>
          </div>
          <div class="setting-item">
            <p>固定HEADER</p>
            <a-switch checked={fixedHeader} size="small" onChange={(e) => {
                this.changeSetting("fixedHeader", e);
              }} />
          </div>
          <div class="setting-item">
            <p>自动隐藏HEADER</p>
            <a-switch checked={autoHideHeader} size="small" onChange={(e) => {
                this.changeSetting("autoHideHeader", e);
              }} />
          </div>
          <div class="setting-item">
            <p>固定侧边栏</p>
            <a-switch checked={fixSiderbar} size="small" onChange={(e) => {
                this.changeSetting("fixSiderbar", e);
              }} />
          </div>
        </div>
      </Drawer>
    );
  },
};
export default SettingDrawer;
