import './Header.less'
import { Layout } from "ant-design-vue";
import GlobalHeader from '@/components/GlobalHeader';
import TopNavHeader from '@/components/TopNavHeader';
import { mapGetters } from "vuex";
const { Header } = Layout;
const HeaderView = {
    props: ['menuData', 'logo'],
    computed: {
        ...mapGetters({
            settings: "global/settings"
        })
    },
    render() {
        const { menuData, logo } = this
        const { layout, navTheme, fixedHeader, leftMenuTitle } = this.settings;
        const isTop = layout === 'topmenu';
        const isMobile = false;

        return (
            <Header style={{ padding: 0 }} class={fixedHeader ? 'fixedHeader' : ''}>
                {isTop && !isMobile ? (
                    // <TopNavHeader
                    //     theme={navTheme}
                    //     mode="horizontal"
                    //     Authorized={Authorized}
                    //     onCollapse={handleMenuCollapse}
                    //     onNoticeClear={this.handleNoticeClear}
                    //     onMenuClick={this.handleMenuClick}
                    //     onNoticeVisibleChange={this.handleNoticeVisibleChange}
                    //     {...this.props}
                    // />
                    <TopNavHeader
                        theme={navTheme}
                        layout={layout}
                        mode="horizontal"
                        menuData={menuData}
                        logo={logo}
                        title={leftMenuTitle}
                    />
                ) : (
                        // <GlobalHeader
                        //     onCollapse={handleMenuCollapse}
                        //     onNoticeClear={this.handleNoticeClear}
                        //     onMenuClick={this.handleMenuClick}
                        //     onNoticeVisibleChange={this.handleNoticeVisibleChange}
                        //     {...this.props}
                        // />
                        <GlobalHeader theme={navTheme} layout={layout}/>
                    )}
            </Header>
        );
    }
}
export default HeaderView;
