# Flask-Migrate

数据库迁移工具：使用Flask-Migrate数据库迁移框架可以保证数据库结构在发生变化时，改变数据库结构不至于丢失数据库的数据。

1. 安装
```
pip install Flask-Migrate
```

2. demo
```
from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate

app = Flask(__name__)
app.config['SQLALCHEMY_DATABASE_URI'] = 'sqlite:///app.db'

db = SQLAlchemy(app)
migrate = Migrate(app, db)

class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(128))
```

3. 初始化

完成文件创建后就可以进行初始化了，切换到文件所在文件夹下，使用命令

```
flask db init
```

这个命令中的**db**是在*manager.py*的*migrate = Migrate(app, db)*这行代码中声明命令行对象名称；

init是Migrate命令，表示初始化迁移数据库，运行完成后会在当前目录下创建一个migrations文件夹，用于进行迁移的数据库脚本都放在这里。

4. 迁移数据库

可以实现数据库迁移仓库创建：

```
flask db migrate -m "Initial migration."
```

此时生成一个versions文件夹：

从数据库中能看到alembic_version表。

5. 更新数据库
```
flask db upgrade
```

6. 总结

+ 一是修改app部分代码，增加与Migrate相关的Command代码；

+ 二是准备好数据模型，即model.py文件中的内容；

+ 三是初始化和更新迁移数据库操作，即3次命令输入。

后面models目录下任何一个数据库表文件增加或者删除了字段，通过以下两步解决：

```
python manager.py db migrate
python manager.py db upgrade
```

详情参考：https://zhuanlan.zhihu.com/p/307612189