'''
Author: your name
Date: 2021-04-22 18:04:10
LastEditTime: 2021-06-30 17:22:15
LastEditors: Please set LastEditors
Description: In User Settings Edit
FilePath: \evm-store\tools\resources\models\__init__.py
'''
# -*- coding: utf-8 -*-
from sqlalchemy import create_engine
from sqlalchemy import Column, Integer, String
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declared_attr, declarative_base

class BaseModelMixin(object):
    @declared_attr
    def __tablename__(self):
        return self.__name__.lower()

    # __table_args__ = {'mysql_engine': 'InnoDB'}

    id = Column(Integer, primary_key=True)

BaseModel = declarative_base(cls=BaseModelMixin)

class MyMixin(object):
    @declared_attr
    def __tablename__(self):
        return self.__name__.lower()

    # __table_args__ = {'mysql_engine': 'InnoDB'}
    __mapper_args__= {'always_refresh': True}

    id = Column(Integer, primary_key=True)

# example:
class MyModel(MyMixin, BaseModel):
    __tablename__ = 'mymodel'
    name = Column(String(20))
    fullname = Column(String(32))
    password = Column(String(32))


# if __name__ == "__main__":
engine = create_engine('sqlite:///test.db')

BaseModel.metadata.create_all(engine, checkfirst=True)

Session = sessionmaker(bind=engine)
session = Session()

ed_user = MyModel(name='ed', fullname='Ed Jones', password='edspassword')
session.add(ed_user)


session.add_all(
    [
        MyModel(name='wendy', fullname='Wendy Williams', password='foobar'),
        MyModel(name='mary', fullname='Mary Contrary', password='xxg527'),
        MyModel(name='fred', fullname='Fred Flinstone', password='blah')
    ]
)
session.commit()

# our_user = session.query(MyModel).filter_by(name='ed').first()
# print(our_user)
